﻿//+------------------------------------------------------------------+
//|                                         Candlestick Patterns.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property script_show_inputs

input uchar Candle=4,
            Level=2,
            Forward=5,
            Pause=5;

int data[],dec[],pattern[][3],size,lvl,forward;
double max[3]= {0},min[3]= {DBL_MAX},step[3];
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   size=3*MathMax(1,Candle);
   lvl=MathMax(2,Level);
   forward=MathMax(1,Forward);
   ArrayResize(data,size);
   ArrayResize(dec,size);

   for(int i=0;i<size;i++)
      dec[i]=(int)MathPow(lvl,i);

   ulong f=(ulong)MathPow(lvl,size);
   if(f>INT_MAX)
     {
      Alert("Exceeding the size!");
      return;
     }
   else
      Print("Number of patterns ",f);

   ArrayResize(pattern,(int)f);
   ArrayInitialize(pattern,0);

//найдем шаг изменения уровней
   int bars=MathMin(iBars(_Symbol,PERIOD_CURRENT),TerminalInfoInteger(TERMINAL_MAXBARS))-1,limit=bars-size;
   double diff[3];
   for(int i=bars;i>0;i--)
     {
      double o=iOpen(_Symbol,PERIOD_CURRENT,i),
             h=iHigh(_Symbol,PERIOD_CURRENT,i),
             l=iLow(_Symbol,PERIOD_CURRENT,i),
             c=iClose(_Symbol,PERIOD_CURRENT,i);

      diff[0]=c-l;
      diff[1]=c-2*l+h;
      diff[2]=c-3*l+3*h-o;

      for(int j=0;j<3;j++)
        {
         max[j]=MathMax(max[j],diff[j]);
         min[j]=MathMin(min[j],diff[j]);
        }
     }

   for(int j=0;j<3;j++)
      step[j]=(max[j]-min[j]+_Point)/lvl;

//
   for(int i=bars;i>limit;i--)
      ShiftData(i);

   for(int i=limit;i>0;i--)
     {
      ShiftData(i);

      int p=0;
      for(int j=0;j<size;j++)
         p=p+data[j]*dec[j];

      if(i>forward)//собираем статистику
        {
         double o=iOpen(_Symbol,PERIOD_CURRENT,i-1),h=0,l=0;
         for(int j=1;j<=forward;j++)
           {
            int pos=i-j;
            h=h+iHigh(_Symbol,PERIOD_CURRENT,pos);
            l=l+iLow(_Symbol,PERIOD_CURRENT,pos);
           }

         pattern[p][0]++;
         pattern[p][1]=pattern[p][1]+(int)MathRound((h/forward-o)/_Point);
         pattern[p][2]=pattern[p][2]+(int)MathRound((l/forward-o)/_Point);
        }

      if(i==1)//строим прогноз
        {
         double o=iOpen(_Symbol,PERIOD_CURRENT,0);
         if(pattern[p][0]>0)//прогноз возможен
            Predict(o+_Point*pattern[p][1]/pattern[p][0],o+_Point*pattern[p][2]/pattern[p][0]);
         else//прогноз невозможен
            Alert("Prediction impossible. This pattern is observed for the first time!");
        }
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void Predict(double h,double l)
  {
//---
   int width=(int)ChartGetInteger(0,CHART_WIDTH_IN_PIXELS,0),
       height=(int)ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS,0);
   datetime t0=iTime(_Symbol,PERIOD_CURRENT,0),t1=t0+forward*PeriodSeconds(PERIOD_CURRENT);

   TrendLine("priceup",h,t0,t1,clrBlue);
   TrendLine("pricedn",l,t0,t1,clrRed);
   ChartRedraw();

   Print("Expected value high = ",NormalizeDouble(h,_Digits)," low = ",NormalizeDouble(l,_Digits));
   Sleep(Pause*1000);

   ChartScreenShot(0,"Candlestick Patterns.png",width,height);
   ObjectsDeleteAll(0,"price");
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void TrendLine(string name,double price,datetime t0,datetime t1,color clr)
  {
//---
   ObjectCreate(0,name,OBJ_TREND,0,t0,price,t1,price);
   ObjectSetInteger(0,name,OBJPROP_WIDTH,3);
   ObjectSetInteger(0,name,OBJPROP_COLOR,clr);
   ObjectSetInteger(0,name,OBJPROP_RAY_LEFT,false);
   ObjectSetInteger(0,name,OBJPROP_RAY_RIGHT,false);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void ShiftData(int i)
  {
//---
   if(size>3)
      for(int i=size-1;i>2;i--)
         data[i]=data[i-3];

   double o=iOpen(_Symbol,PERIOD_CURRENT,i),
          h=iHigh(_Symbol,PERIOD_CURRENT,i),
          l=iLow(_Symbol,PERIOD_CURRENT,i),
          c=iClose(_Symbol,PERIOD_CURRENT,i);

   data[0]=(int)MathFloor((c-l-min[0])/step[0]);
   data[1]=(int)MathFloor((c-2*l+h-min[1])/step[1]);
   data[2]=(int)MathFloor((c-3*l+3*h-o-min[2])/step[2]);
//---
  }
//+------------------------------------------------------------------+
